proc tabulate data = ghpb14;
class health_only ent2 INS3 filingsize / PRELOADFMT;
var subtl_act_rtd_sep_CNE tot_assets_eoy_AME tot_liabilities_eoy_AME / WEIGHT=DUP_WGT;
VAR DUP_WGT;
title 'Table A2. Number of Group health Plans, Participants, Assets, and Liabilities';
title2 'by type of insurance and type of plan, 2014';
title3 'All Plans';
table (SUM=' '*DUP_WGT='Number of Plans'*f=comma12. subtl_act_rtd_sep_CNE='Participants (thousands)'*sum=' '*f=k12f. tot_assets_eoy_AME='Assets (millions)'*sum=' '*f=m12f_2stars.
tot_liabilities_eoy_AME='Liabilities (millions)'*sum=' '*f=m12f_2stars.)*(all='Total' health_only=' '), (all='Total' INS3=' ')*(all='Total' ent2=' ')/MISSTEXT='-';
run;

proc tabulate data = ghpb14;
class health_only ent2 INS3 filingsize / PRELOADFMT;
var subtl_act_rtd_sep_CNE tot_assets_eoy_AME tot_liabilities_eoy_AME / WEIGHT=DUP_WGT;
WHERE FILINGSIZE='1';
VAR DUP_WGT;
title 'Table A2. Number of Group health Plans, Participants, Assets, and Liabilities';
title2 'by type of insurance and type of plan, 2014';
title3 'Plans with 100 or More Participants & Trusts';
table (SUM=' '*DUP_WGT='Number of Plans'*f=comma12. subtl_act_rtd_sep_CNE='Participants (thousands)'*sum=' '*f=k12f. tot_assets_eoy_AME='Assets (millions)'*sum=' '*f=m12f_2stars.
tot_liabilities_eoy_AME='Liabilities (millions)'*sum=' '*f=m12f_2stars.)*(all='Total' health_only=' '), (all='Total' INS3=' ')*(all='Total' ent2=' ')/MISSTEXT='-';
run;

proc tabulate data = ghpb14;
class health_only ent2 INS3 filingsize / PRELOADFMT;
var subtl_act_rtd_sep_CNE tot_assets_eoy_AME tot_liabilities_eoy_AME / WEIGHT=DUP_WGT;
WHERE FILINGSIZE='2';
VAR DUP_WGT;
title 'Table A2. Number of Group health Plans, Participants, Assets, and Liabilities';
title2 'by type of insurance and type of plan, 2014';
title3 'Plans with 100 or More Participants & No Trusts';
table (SUM=' '*DUP_WGT='Number of Plans'*f=comma12. subtl_act_rtd_sep_CNE='Participants (thousands)'*sum=' '*f=k12f. tot_assets_eoy_AME='Assets (millions)'*sum=' '*f=m12f_2stars.
tot_liabilities_eoy_AME='Liabilities (millions)'*sum=' '*f=m12f_2stars.)*(all='Total' health_only=' '), (all='Total' INS3=' ')*(all='Total' ent2=' ')/MISSTEXT='-';
run;

proc tabulate data = ghpb14;
class health_only ent2 INS3 filingsize / PRELOADFMT;
var subtl_act_rtd_sep_CNE tot_assets_eoy_AME tot_liabilities_eoy_AME / WEIGHT=DUP_WGT;
WHERE FILINGSIZE='3';
VAR DUP_WGT;
title 'Table A2. Number of Group health Plans, Participants, Assets, and Liabilities';
title2 'by type of insurance and type of plan, 2014';
title3 'Plans with Fewer Than 100 Participants & Trusts';
table (SUM=' '*DUP_WGT='Number of Plans'*f=comma12. subtl_act_rtd_sep_CNE='Participants (thousands) 3/'*sum=' '*f=k12f. tot_assets_eoy_AME='Assets (millions)'*sum=' '*f=m12f_2stars.
tot_liabilities_eoy_AME='Liabilities (millions)'*sum=' '*f=m12f_2stars.)*(all='Total' health_only=' '), (all='Total' INS3=' ')*(all='Total' ent2=' ')/MISSTEXT='-';
run;
